function Add = CreatePadding(handles,image)
%% Create Padding
% padding is useful for creating periodic boundarys
% here, a method is chosen to conserve the hight and slope of the end of
% the array. Else, denoising and especially deconvolution would tear the
% endpoints downwards in order to "smooth" the start with the end of the array
% within periodic boundarys.

%% Get handles
Cut        = get(handles.EstimatePhi,'UserData');
ZLPPos     = get(handles.AlignPanel,'UserData');
Fine       = get(handles.AlignPanel,'UserData');
Phi        = str2double(get(handles.PhiVal,'String'));
ZLPPos1    = ZLPPos(1,2)+Cut(1,1);
ZLPPos2    = ZLPPos(1,3)+Cut(1,1);

Gain       = str2double(get(handles.GainVal,'String'));
readstd    = str2double(get(handles.ReadStd,'String'));
Corr       = get(handles.PSF,'UserData');

Add        = image(:,:,ZLPPos1:ZLPPos2);

if ~isempty(Corr{1,1})
    add        = reshape(Add,[size(Add,1)*size(Add,2),size(Add,3)]);
    add        = mean(add,1);
    add        = add./max(add,[],2);
    PSFEELS    = Corr{1,1};
    PSFFactor  = PSFEELS./max(PSFEELS,[],2);
    SizeDiff   = (size(PSFFactor,2) - size(add,2)+1)/2;
    PSFFactor  = PSFFactor(1,ceil(SizeDiff):end-floor(SizeDiff));
    PSFFactor  = ifftshift(PSFFactor)./sum(PSFFactor,2);
    PSFFactor  = ifft(fft(PSFFactor,[],2).*fft(add,[],2),[],2);
    PSFFactor  = max(PSFFactor,[],2)^(-1);
else
    PSFFactor  = 1;
end

StartPoint = mean(image(:,:,1:5),3);
EndPoint   = mean(image(:,:,end-5:end),3);                                  % sets the endpoint as mean value of the last 5 points


Add        = reshape(Add,[size(Add,1)*size(Add,2),size(Add,3)]);
Add        = mean(Add,1);
[~,Ind]    = max(Add,[],2);

Add        = Add-min(Add,[],2);
Add        = Add./max(Add,[],2);

Add        = reshape(Add,[1,1,size(Add,2)]);
Add        = repmat(Add,[size(image,1),size(image,2)]);
Add        = Add.*repmat((EndPoint-StartPoint).*PSFFactor,[1,1,size(Add,3)])+repmat(StartPoint,[1,1,size(Add,3)]);

if PSFFactor~=1
    SizeDiff  = (size(PSFEELS,2) - size(Add,3)+1)/2;
    PSFEELS   = PSFEELS(1,ceil(SizeDiff):end-floor(SizeDiff));
    
    PSFEELS   = ifftshift(PSFEELS)./sum(PSFEELS,2);
    PSFEELS   = reshape(PSFEELS,[1,1,size(PSFEELS,2)]);
    PSFEELS   = repmat(PSFEELS,[size(Add,1),size(Add,2),1]);
    Add       = Add./(Gain).*10^(-12);
    Add       = imnoise(Add,'poisson');
    Add       = Add.*10^(12).*(Gain);
    
    Add       = ifft(fft(Add,[],3).*fft(PSFEELS,[],3),[],3);
    Add       = sign(real(Add)).*abs(Add);
else
    Add        = Add./(Gain).*10^(-12);
    Add        = imnoise(Add,'poisson');
    Add        = Add.*10^(12).*(Gain);
end
Add        = Add(:,:,Ind:end);

ReadStd    = randn((size(Add))).*readstd;

if Fine(1,1)==2
    PSFInter  = Corr{1,5};
    SizeDiff  = (size(PSFInter,2) - size(ReadStd,3)+1)/2;
    PSFInter  = PSFInter(1,ceil(SizeDiff):end-floor(SizeDiff));
    PSFInter  = ifftshift(PSFInter)./sum(PSFInter,2);
    PSFInter  = reshape(PSFInter,[1,1,size(ReadStd,3)]);
    PSFInter  = repmat(PSFInter,[size(ReadStd,1),size(ReadStd,2),1]);
    
    ReadStd   = ifft(fft(ReadStd,[],3).*fft(PSFInter,[],3),[],3);
    ReadStd   = sign(real(ReadStd)).*abs(ReadStd);
    
    ReadBack  = randn((size(Add(1,1,:)))).*readstd./(sqrt(size(Add,1)*size(Add,2))).*sqrt(Phi);
    ReadBack  = ifft(fft(ReadBack,[],3).*fft(PSFInter(1,1,:),[],3),[],3);
    ReadBack  = sign(real(ReadBack)).*abs(ReadBack);
    ReadBack  = repmat(ReadBack,[size(Add,1),size(Add,2),1]);
else
    ReadBack=0;
end

Add        = Add + ReadStd + ReadBack;                              % adds Gaussian noise to padding to better merge with spectra

clearvars -except Add
end